--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A data structure, off of the world controller, that handles input.
--- @class tes3inputController
--- @field creationFlags number *Read-only*. A bit field representing device capabilities and settings.
--- @field inputMaps tes3inputConfig[] *Read-only*. The array-style access to input bindings. To index this array use [tes3.keybind](https://mwse.github.io/MWSE/references/keybinds/) constants increased by `1`. For example, to get the input binding for steal action, you would do: `inputController.inputMaps[tes3.keybind.sneak + 1]`.
--- @field keyboardState number[] *Read-only*. The array-style access to raw key states.
--- @field mouseState tes3directInputMouseState *Read-only*. The raw DirectInput mouse state.
--- @field previousKeyboardState number[] *Read-only*. The array-style access to the previous frame's raw key states.
--- @field previousMouseState tes3directInputMouseState *Read-only*. The raw DirectInput mouse state for the previous state.
tes3inputController = {}

--- Returns true if either alt modifier key is pressed.
--- @return boolean isPressed True if either alt key is pressed.
function tes3inputController:isAltDown() end

--- Returns true if the caps lock mode is active.
--- @return boolean isPressed True if caps lock is active.
function tes3inputController:isCapsLockActive() end

--- Returns true if either control modifier key is pressed.
--- @return boolean isPressed True if either control key is pressed.
function tes3inputController:isControlDown() end

--- Performs a key down test for a given scan key code.
--- @param key tes3.scanCode The scan code to test. Constants available through [`tes3.scanCode`](https://mwse.github.io/MWSE/references/scan-codes/).
--- @return boolean result No description yet available.
function tes3inputController:isKeyDown(key) end

--- Checks to see if a given scan code is pressed, and wasn't pressed last frame.
--- @param key tes3.scanCode The scan code to test. Constants available through [`tes3.scanCode`](https://mwse.github.io/MWSE/references/scan-codes/).
--- @return boolean result No description yet available.
function tes3inputController:isKeyPressedThisFrame(key) end

--- Checks to see if a given scan code is released, and was pressed last frame.
--- @param key tes3.scanCode The scan code to test. Constants available through [`tes3.scanCode`](https://mwse.github.io/MWSE/references/scan-codes/).
--- @return boolean result No description yet available.
function tes3inputController:isKeyReleasedThisFrame(key) end

--- Returns the mouse down state for a given mouse button.
--- @param button number The mouse button to test. Must be between `0` and `7`. Left mouse button is `0`, right is `1`, and middle is `2`.
--- @return boolean result No description yet available.
function tes3inputController:isMouseButtonDown(button) end

--- Returns true if a mouse button was up last frame, and down this frame.
--- @param button number The mouse button to test. Must be between `0` and `7`. Left mouse button is `0`, right is `1`, and middle is `2`.
--- @return boolean result No description yet available.
function tes3inputController:isMouseButtonPressedThisFrame(button) end

--- Returns true if a mouse button was down last frame, and up this frame.
--- @param button number The mouse button to test. Must be between `0` and `7`. Left mouse button is `0`, right is `1`, and middle is `2`.
--- @return boolean result No description yet available.
function tes3inputController:isMouseButtonReleasedThisFrame(button) end

--- Returns true if either shift modifier key is pressed. It does not take into account caps lock.
--- @return boolean isPressed True if either shift key is pressed.
function tes3inputController:isShiftDown() end

--- Returns true if either super/windows modifier key is pressed.
--- @return boolean isPressed True if either super/windows key is pressed.
function tes3inputController:isSuperDown() end

--- Performs a test for a given keybind, and optionally a transition state.
--- @param key tes3.keybind The keybind to test. Constants available through [`tes3.keybind`](https://mwse.github.io/MWSE/references/keybinds/).
--- @param transition? tes3.keyTransition *Optional*. Transition state, e.g. down, or up. Constants available through [`tes3.keyTransition`](https://mwse.github.io/MWSE/references/key-transitions/).
--- @return boolean result No description yet available.
function tes3inputController:keybindTest(key, transition) end

